*
* Initialize variable, prepare for environment setup.
*
SET PROCEDURE TO utility
ON ERROR DO errorhandler WITH MESSAGE(), LINENO()
CLEAR PROGRAM
CLEAR GETS

IF SET("TALK") = "ON"
	SET TALK OFF
	m.talkstat = "ON"
ELSE
	m.talkstat = "OFF"
ENDIF

mdevice  = ""
m.area   = 0
m.exact  = ""
m.safety = ""
m.deci   = 0
m.escap  = ""
m.noti   = ""
m.deli   = ""
m.memow  = 0
m.oldhelp = SET("HELP",1)
m.helpset = SET("HELP")
m.resoset = SET("RESOURCE")
m.oldreso = SET("RESOURCE",1)

IF TYPE("m.hidecomm") = "U"
	m.hidecomm = WVISIBLE("command")
ENDIF

m.macrosave = "savmacro.fky"
m.idlequit = .F.
m.module   = LOWER(stripext(strippath(SYS(16))))
m.tobedone = m.module + ".spr"


IF rdlevel() = 0
	oldtitle = wtitle('screen')
	oldfont = wfont(1,oldtitle)
	oldsize = wfont(2,oldtitle)
	oldstyle = wfont(3,oldtitle)
	modify window screen font "MS Sans Serif",8
	clear
	fromrow = wlrow()
	fromcol = wlcol()
	torow = wrows()
	tocol = wcols()

	if wrows() <  32.538
		modify window screen at 0,0 size 32.538,wcols()
	endif
	if wcols() < 120
		modify window screen at 0,0 size wrows(),120
	endif
	MOVE WINDOW SCREEN CENTER

	SET TALK OFF
	progpath = SYS(16)
	npath = SUBSTR(progpath,1,RAT('\',progpath)-1)

	conv1 = '"' + npath + "\convert.app" + '"'
	rest1 = '"' + npath + "\restaurs.app" + '"'
	clie1 = '"' + npath + "\clients.app" + '"'
	fami1 = '"' + npath + "\family.app" + '"'
	cred1 = '"' + npath + "\credit.app" + '"'
	cred1 = '"' + npath + "\credit.app" + '"'
	accn1 = '"' + npath + "\accnts.app" + '"'
	tran1 = '"' + npath + "\trans.app" + '"'

	opath = SET("PATH")
	rootpath = npath
	npath = npath + "\REPORTS"
	IF AT(npath+";",opath)=0 AND ;
		RAT(rootpath,opath)+LEN(npath)-1-LEN(opath)<>0
		opath =	npath + IIF(EMPTY(opath),"",";") + opath
	ENDIF
	npath =	rootpath + "\DBFS"
	IF AT(npath+";",opath)=0 AND ;
		RAT(rootpath,opath)+LEN(npath)-1-LEN(opath)<>0
		opath =	npath + IIF(EMPTY(opath),"",";") + opath
	ENDIF
	IF AT(rootpath+";",opath)=0 AND ;
		RAT(rootpath,opath)+LEN(rootpath)-1-LEN(opath)<>0
		opath =	rootpath + IIF(EMPTY(opath),"",";") + opath
	ENDIF
	SET PATH TO &opath
	m.moldhelp = SET("HELP",1)
	m.mhelpset = SET("HELP")
	SET HELP TO "orghelp.dbf"
	SET HELP ON
ENDIF

DO setup

PUSH MENU _msysmenu
RELEASE POPUPS organizer, moneymanag

DO mainmenu.mpr

*
* Launch the GET-LESS READ.
*
READ WHEN dofirstapp() ;
	VALID idleloop()

*
* Cleanup and reset the environment.
*

POP MENU _msysmenu
*CLEAR WINDOW ALL

DO cleanup
DO closdbfs
SET COLOR OF SCHEME 1 TO
IF RDLEVEL() = 0
	SET PROCEDURE TO
	IF NOT EMPTY(m.moldhelp)
		RELEASE WINDOW 'HELP'
		SET HELP TO LOCFILE(m.moldhelp, "DBF", "Where is "+m.moldhelp+" help file?")
		IF m.mhelpset = "ON"
			SET HELP ON
		ELSE
			SET HELP OFF
		ENDIF
	ELSE
		SET HELP OFF
	ENDIF
	modify window screen at fromrow,fromcol size torow,tocol
	modify window screen font oldfont,oldsize style oldstyle

	?sys(2017)
ENDIF

*!*********************************************************************
*!
*!       Function: DOFIRSTAPP()
*!
*!      Called by: IDLEREAD.PRG                  
*!
*!*********************************************************************
*
* DOFIRSTAPP - Trigger the first application by forcing the FOUNDATION
*				READ to evaluate its VALID clause.
*
FUNCTION dofirstapp
CLEAR READ

*!*********************************************************************
*!
*!       Function: IDLELOOP()
*!
*!      Called by: IDLEREAD.PRG                  
*!
*!*********************************************************************
*
* IDLELOOP - Processing in the idle loop.
*
FUNCTION idleloop
PRIVATE m.temp, m.ontop

IF m.idlequit
	RETURN .T.
ENDIF

IF LEN(m.tobedone) > 0
	m.temp = m.tobedone
	m.tobedone = ""
	DO (m.temp)
	RETURN .F.
ENDIF

m.ontop = LOWER(WONTOP())

DO CASE
CASE m.ontop = "convert"
	DO (m.ontop+".app")
CASE m.ontop = "family" OR m.ontop = "restaurs" OR ;
		m.ontop = "credit" OR m.ontop = "accnts" OR ;
		m.ontop = "trans"
	SHOW WINDOW controls TOP
	IF m.ontop = "accnts"
		SHOW WINDOW 'Details' TOP
	ENDIF
	DO (m.ontop+".spr")
CASE m.ontop = "details" OR m.ontop = "details.service"
	m.temp = "accnts.spr"
	SHOW WINDOW "Details" TOP
	SHOW WINDOW controls TOP
	DO (m.temp)
CASE m.ontop = "controls"
	m.temp = ""
	DO CASE
	CASE WVISIBLE("family")
		m.temp = "family.spr"
	CASE WVISIBLE("restaurs")
		m.temp = "restaurs.spr"
	CASE WVISIBLE("credit")
		m.temp = "credit.spr"
	CASE WVISIBLE("trans")
		m.temp = "trans.spr"
	CASE WVISIBLE("accnts")
		m.temp = "accnts.spr"
		SHOW WINDOW "Details" TOP
	ENDCASE
	IF NOT EMPTY(m.temp)
		SHOW WINDOW controls TOP
		DO (m.temp)
	ENDIF
ENDCASE

RETURN .F.

*: EOF: IDLEREAD.PRG
