#ifndef __CALENDAR_H
#define __CALENDAR_H


#include "bstring.h"
#include "vector.h"
#include <DOS.H>
#include "data.h"
#include "gifford.h"
#include "gui.h"


/* IMPORTANT!

	At some point a person may need to change the inline copying of
	the mouse to an external copy in the constructor.  So instead
	of the_mouse (mouse) where Mcursor & the_mouse in the header file,
	may need to be Mcursor the_mouse in the header and in the constructor
	the_mouse = mouse. */


class calendar
	{
	public:
		calendar(int m, int y, bstring hm, Mcursor & mouse); // month, day, year
		~calendar();

		void add (); // this is the only other function that can be
			     // outside of calendar.
		int show (int mode = 1);
			// you may call show_calendar (0) and it will not
			// search for data.  Returns (-1) if ESC or EXIT
			// selected OR if search was selected (in which
			// case it sets the_search == 1.
			// Otherwise returns day number.

		int		day;
		int		month;
		int		year;

		long int	the_add;
		/* if an add is requested the_add gets set to 1, otherwise
		   it is zero. */

		int		the_search;
		/* if the search command is called, calendar exists and
		   sets this flag = 1.  It also sets the_string to the
		   search pattern requested. */
		bstring		the_string;

	private:

		int total_buttons; // total # of buttons

		int loop (int mode = 1);

		int the_color;

		void display (int mode = 1);  // calls the below functions

	/* The following functions must be called in the order shown */
		void find_days ();  // (optional) scans notes for days
		void show_display (); // displays misc. information
		void show_titles ();
		void set_buttons (int add_mode = 0);  /* prepares buttons (days)
				this function, if set to add_mode = 1 only
				will prepare the calendar buttons (1,2,3,etc)
				and the exit button. */
		void show_tiles (); // shows the tiles

		void calendar_help ();

		void jump_to_date ();

		void search ();

		void credit ();

		void clear_calendar ();
		void clear_search ();
		void clear_date ();
		void gr_clear();
		void write3d (int y,char *text);


		Acticon 	credit_icon;

		vector<Button>	buttons;
		data		the_data;
		gifford		manip;
		vector<int>	the_days;
		struct date	d;

		int 		num_days;


		int		maxx, maxy;

		int 		spacing;

		bstring	home;
		Mcursor & the_mouse;
	};

#endif /* __CALENDAR_H */