#include "jgmatch.h"

jgmatch::jgmatch (const bstring & pat, const bstring & txt) : pattern(pat), text(txt), num_array (256)
	{
// clear array
	for (int i = 0; i < 256; i++)
		num_array[i] = 0;

// copy into array the positions of each character in the pattern
	for (int j = 0; j < pattern.length(); j++)
		num_array[pattern[j]] = j;
	}

jgmatch::~jgmatch ()
	{
	}

int jgmatch::is_match ()
	{
// holds the position in the text we are currently examining
	int pos = 0;
	int lastpos = text.length() - pattern.length();

	while (pos <= lastpos)
		{

// holds the position in the pattern we are currently examining
		int pat_pos = pattern.length() -1;

/* let's rotate through the pattern and check it against the text at our
   current position. */
		while (pat_pos >= 0 && text[pos + pat_pos] == pattern[pat_pos])
			pat_pos -= 1;

// check to see if we've found a match
		if (pat_pos < 0)
			return 1; // found a match

// no, well we'll advance the position in the text we are examining
		int advance = pat_pos - num_array[text[pos+pat_pos]];
/*		     ^^  	^^        ^^         ^^^^^^^^^^^^
		    temp.     pattern    see        whatever's in the
		    pos.	pos.   constuctor  text @ pos (in the text)
						   + the position we failed @ */

/* don't want to advance backwards, so we'll make sure of that here
   also, if there is no position at num_array we'll just advance forward
   one */
		if (advance < 1)
			advance = 1;

// advance the position we are examining in the text by pos
		pos += advance;
		}
	return 0;
	}